# Tree of Knowledge – Download & Run Instructions

This page explains how to download and run both calculators on your computer:

• **First‑Order Logic Calculator** (main calculator)
• **SIMPLE Propositional Tree – Beginner Mode**

Both calculators are distributed as portable **.jar** files and require only Java to run.

---

## 1. System Requirements

✅ Windows, macOS, or Linux
✅ **Java 17 or newer** installed

### Check if Java is installed

Open **Terminal / Command Prompt** and type:

```
java -version
```

If you see a version number (17 or higher), you’re ready.
If not, install Java from:
[https://adoptium.net](https://adoptium.net)

> **NOTE:** IF YOU DON’T KNOW HOW TO INSTALL JAVA, PLEASE ASK CHATGPT — IT WILL GUIDE YOU STEP BY STEP.

---

## 2. First‑Order Logic Calculator (MAIN)

### Download

Click the button:

**Download on PC 💻 & RUN**

This will download:

```
StabloSpoznaje-1.0.0-jar-with-dependencies.jar
```

### Run

1. Go to your **Downloads** folder
2. **Double‑click** the file

If double‑click does not start it:

```
Right click → Open with → Java Platform
```

Or via terminal:

```
java -jar StabloSpoznaje-1.0.0-jar-with-dependencies.jar
```

---

## 3. SIMPLE Propositional Tree – Beginner Mode

### Download

Click the button in the **SIMPLE PROPOSITIONAL TREE – BEGINNER MODE** section:

**Download on PC 💻 & RUN**

This will download:

```
PropositionalTree-1.0.0-jar-with-dependencies.jar
```

### Run

1. Go to your **Downloads** folder
2. **Double‑click** the file

Or via terminal:

```
java -jar PropositionalTree-1.0.0-jar-with-dependencies.jar
```

---

## 4. Security Notice (Windows)

Windows may display:

“**Windows protected your PC**”

This is normal for custom educational software.

To proceed:

1. Click **More info**
2. Click **Run anyway**

---

## 5. Troubleshooting

**Problem:** File does not open
**Solution:** Install Java (see Section 1)

---

**Problem:** Nothing happens on double‑click
**Solution:** Use terminal:

```
java -jar filename.jar
```

---

## 6. Source Code

Source code download is temporarily disabled and will be enabled in the next release.

---

## 7. Contact

If you experience any problems, feel free to contact:

📧 [janica.tesla.zrinski@gmail.com](mailto:janica.tesla.zrinski@gmail.com)
📧 [ana.kovacevic77@gmail.com](mailto:ana.kovacevic77@gmail.com)

---

© All rights reserved – Tree of Knowledge